﻿var panelSample = {
    pageTable: null,
    page: null,
    canModifySample: $('.CanModifySample').val() == "True",
    canDeleteSample: $('.CanDeleteSample').val() == "True"
};

$(document).ready(function () {

    $(".v-addSample").on("click", function () {
        modalDialog.showWindow(a4.getAction("SampleEditor", "Samples", "Panel"), 600, 1000, { afterClose: function () { panelSample.pageTable.a4datatable("refresh"); } });
    });

    panelSample.pageTable = $(".samplesTable").a4datatable({
        height: "full",
        ajaxAction: a4.getAction("GetSamples", "Samples", "Panel"),
        columns: [
            { "Name": "Id", "Title": resources.Id, "Data": "Id", "Type": "numeric" },
            { "Data": "Message", "Tooltip": true },
            { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
            { "Name": "Size", "Title": resources.Size, "Data": "Size", "HideInSelector": true },
            { "Name": "MaxSize", "Title": resources.MaxSize, "Data": "MaxSizeDisplay" },
            { "Name": "Status", "Title": resources.Status, "Data": "Status", "Type": "Enum" },
            { "Name": "SurveyName", "Title": resources.Survey, "Data": "SurveyName" },
            { "Name": "Dynamic", "Title": resources.Dynamic, "Data": "DynamicLabel", "Type": "boolean" },
            { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy" },
            { "Name": "ModifiedOn", "Title": resources.ModifiedOn, "Data": "ModifiedOn", "Type": "date" },
            { "Name": "LastExecutionDate", "Title": resources.LastExecutionDate, "Data": "LastExecutionDate", "Visible": false },
            { "Name": "ScheduleDate", "Title": resources.NextRun, "Data": "ScheduleDate", "Visible": false },
            { "Name": "ScheduleType", "Title": resources.ScheduleType, "Data": "ScheduleTypeLabel", "Visible": false }
            
        ],
        defaultSorting: "Name",
        autoUpdate: true,
        contextMenuItems: GetContextMenuItems(),
        contextMenuClick: function (event, data) {
            var row = data.row;
            var action = data.action;
            var self = $(this);

            if (action == "properties") {
                modalDialog.showWindow(a4.getAction("SampleEditor", "Samples", "Panel", { id: row.Id }), 600, 1000, { afterClose: function () { panelSample.pageTable.a4datatable("refresh"); } });
            }
            else if (action == "editSchedule") {
                modalDialog.showWindow(a4.getAction("PanelSampleScheduleEditor", "Shared", "Home", { surveyId: 0, taskId: row.LinkedTaskId }), 600, 850, { afterClose: function () { panelSample.pageTable.a4datatable("refresh"); } });
            }
            else if (action == "copy") {
                modalDialog.showWindow(a4.getAction("SampleEditor", "Samples", "Panel", { copy: true, id: row.Id }), 600, 1000);
            }
            else if (action == "update") {
                a4.callServerMethod(a4.getAction("UpdateSample", "Samples", "Panel"), { id: row.Id }, function (result) {
                    self.a4datatable("refresh");
                });
            }
            else if (action == "link") {
                modalDialog.showWindow(a4.getAction("LinkToSurvey", "Samples", "Panel", { sampleId: row.Id }), 450, 700, { afterClose: function () { panelSample.pageTable.a4datatable("refresh"); } });
            }
            else if (action == "export") {
                a4.parent().ExportPanelists(null, row.Id);
            }
            else if (action == "delete") {
                modalDialog.showConfirmDialog(confirmDeleteSampleResources, function () {
                    a4.callServerMethod(a4.getAction("DeleteSelected", "Samples", "Panel"), { ids: [row.Id] }, function (result) {
                        self.a4datatable("refresh", true);
                    });
                }, 250, 500, true, { "count": 1 });
            }
        },
        stateKey: "PanelSamples",
        toolBarItems: GetToolBarItems(),
        toolBarClick: function (event, data) {
            var action = data.action;
            var rows = data.rows;
            var self = $(this);

            if (action == "deleteSelected") {
                modalDialog.showConfirmDialog(confirmDeleteSampleResources, function () {
                    a4.callServerMethod(a4.getAction("DeleteSelected", "Samples", "Panel"), { ids: _.pluck(rows, "Id") }, function (result) {
                        self.a4datatable("refresh");
                    },
                    function (error) {
                        ShowAjaxErrorMessage(error);
                    });
                }, 250, 500, true, { "count": rows.length });
            }
        },
        localizableTexts: { "Search": resources.SearchSamples },
    });

    function GetToolBarItems() {
        var items = Array();

        if (panelSample.canDeleteSample) {
            items.push({ "Action": "deleteSelected", "Label": resources.Delete });
        }

        return items;
    }

    function GetContextMenuItems() {
        var items = Array();

        if (panelSample.canModifySample) {
            items.push({ "Action": "update", "Label": resources.Update, "DisplayCondition": function (data) { return (_.contains([1, 4], data.StatusValue) || (data.StatusValue == 3 && data.CanUpdateLinkedSurvey)) && data.PanelistFilterId != null; } });
            items.push({ "Action": "link", "Label": resources.LinkToSurvey, "DisplayCondition": function (data) { return data.StatusValue == 1;} });
            items.push({ "Divider": true });

            items.push({ "Action": "copy", "Label": resources.Copy, "DisplayCondition": function (data) { return _.contains([1, 3], data.StatusValue) && data.PanelistFilterId != null;} });

            if (panelSample.canDeleteSample)
                items.push({ "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return _.contains([1, 3, 4], data.StatusValue);} });

            items.push({ "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return _.contains([1, 3, 4], data.StatusValue) && data.PanelistFilterId != null; } });
            items.push({ "Action": "editSchedule", "Label": resources.EditSchedule, "DisplayCondition": function (data) { return _.contains([1, 3, 4], data.StatusValue) && data.PanelistFilterId != null && data.CanUpdateLinkedSurvey && data.LinkedTaskId != null; } });
            items.push({ "Divider": true });
        }

        items.push({ "Action": "export", "Label": resources.Export, "DisplayCondition": function (data) { return _.contains([1, 3], data.StatusValue);} });

        return items;
    }
});